/*---------------------------------------------------------------------------+
| PMSPY common include file
|
| Change History:
| ---------------
| $C1 =1.01,06/14/89,smd,'highlight' CHECKBOX in FILTER dialog
| $C2 =1.01,06/14/89,smd,FormatMsg now returns PMSG_ITEM
| $C3 =1.02,06/17/89,jvk,added logging of messages to a file
| $C4 =1.03,06/19/89,smd,added HELP dialog parameter structure
| $C5 =1.03,06/19/89,smd,added HELP button to FILTER dialog
| $C6 =1.03,06/19/89,smd,added GROUP dialog
| $C7 =1.03,06/20/89,smd,adjust msg list drawing colors
| $C8 =1.10,06/24/89,jvk,added command line parameter support
| $C9 =1.11,06/26/89,jvk,added profile support
| $C10=1.12,06/30/89,smd,GROUP table maintenance required for SAVEing
| $C11=1.12,06/30/89,smd,make important GLOBAL data 'near' (performance)
| $C12=1.12,06/30/89,smd,change HIGHLIGHT checkbox to edit field
| $C13=1.12,07/05/89,smd,change HIGHLIGHT checkbox to COLOR pushbuttons
| $C14=2.10,12/12/89,smd,added OBJECT window box, enhance DLL support
|
+---------------------------------------------------------------------------*/

#define INCL_BASE
#define INCL_GPI
#define INCL_WIN

#include <os2.h>                        /* the PM header file           */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>                     /* C variable parm functions  */
#include "filedlg.h"                    /* @C3A - filedlg include file */

#define ID_MAINWND           1

/* Menu Action Bar items */

#define ID_AB_SPYON          100
#define ID_SELECT            101
#define ID_DESELECT          102
#define ID_SELECT_OBJECT     103                            // @C14

#define ID_AB_SPYWHAT        200
#define IDD_WND              201
#define IDD_QUE              202

#define ID_AB_OPTIONS        300

#define ID_O_CLEAR           310
#define ID_O_FREEZE          311
#define ID_O_THAW            312

#define ID_O_STARTLOG        320        /* @C3A - Start Menu ID  */
#define ID_O_STOPLOG         321        /* @C3A - Stop Menu ID   */

#define ID_O_BROWSEDEFAULT   330

#define ID_AB_FILTER         400
#define ID_F_INCLUDE         401
#define ID_F_EXCLUDE         402
#define ID_F_SELECTIVE       403
#define ID_F_GROUP           404        /* @C6A - Group filtering */

#define ID_AB_FILE           500
#define ID_F_OPENLOG         510        /* @C3A - Logfile MenuID */
#define ID_F_CLOSELOG        511
#define ID_F_OPENPROFILE     520        /* @C9A - Open Profile   */
#define ID_F_APPENDPROFILE   521        /* @C9A - Append Profile   */
#define ID_F_SAVEPROFILE     530        /* @C9A - Save Profile   */
#define ID_F_OPENDEFAULT     540
#define ID_F_APPENDDEFAULT   541
#define ID_F_EXIT            550

#define ID_AB_HELP           600
#define ID_H_HELP            610
#define ID_H_EXTENDED        611
#define ID_H_KEYS            612
#define ID_H_INDEX           613
#define ID_H_TUTORIAL        614
#define ID_H_ABOUT           615
#define ID_H_NEWS            616
#define ID_H_BASICS          617

/* Help Dialog */

#define IDD_HELP             1000

/* Selective Message Filtering Dialog */

#define IDD_FILTER           2000

#define ID_PB_F_INCLUDE      2100
#define ID_PB_F_EXCLUDE      2101
#define ID_PB_F_HELP         2102
#define ID_PB_F_DELETE       2103

/*** @C6A - GROUP Selection Dialog ***/

#define ID_GRP_DLG           3000

#define ID_GRP_LB_GROUPS     3100

#define ID_GRP_PB_INCLUDE    3200
#define ID_GRP_PB_EXCLUDE    3201
#define ID_GRP_PB_HELP       3202
#define ID_GRP_PB_DELETE     3203

/* Common LISTBOX ID */

#define ID_LB_COLORS         4000

/*** ABOUT Dialog ***/

#define IDD_ABOUT            5000
#define IDD_ABOUTICON        5100

/*** @C14A - OBJECT Window Selection Dialog ***/

#define ID_OW_DLG                 6000
#define ID_OW_LIST                6100
#define ID_OW_PB_SPYON            6200
#define ID_OW_PB_REFRESH_ALL      6201
#define ID_OW_PB_REFRESH_PGMR     6202
#define ID_OW_PB_HELP             6203

/* Programmer Define Resource definitions */

#define IDT_HELP        256         /* Help Resource Type */

#define IDT_AB_HELP       1         /* @C5C */
#define IDT_F_HELP        2         /* @C5A */
#define IDT_GRP_HELP      3         /* @C6A */
#define IDT_NEWS          4         /* @C6A */
#define IDT_DEFAULTS      5
#define IDT_OW_HELP       6         // @C14A

#define ID_SPY_POINTER  310

#define VERSION         210         /* 2.10 */
#define DLLVERSION      003         /* 0.03 */

/*************************************************************************
*
* STRINGTABLE items
*
*************************************************************************/

/* This is who we are... */

#define IDS_TITLE                         0

/* .RC based program control items */

#define IDS_MAX_MESSAGES                  1     /* Max # messages in LISTBOX */
#define IDS_MAX_MSG_PERCENT               2     /* Max % of widest MSG to include in LISTBOX */
#define IDS_MAX_PM_Q_SIZE                 3     /* Max % elements for PM Queue */

/* This is our DLL's name */

#define IDS_DLL_NAME                      4

/* printf/fprintf format strings */

#define IDS_FMT_FILTER_ITEM               5
#define IDS_FMT_GRP_INCLUDED              6
#define IDS_FMT_GRP_EXCLUDED              7
#define IDS_FMT_LEVEL                     8
#define IDS_FMT_MSG_INCLUDED              9
#define IDS_FMT_MSG_EXCLUDED             10
#define IDS_FMT_OK_TO_EXIT               11
#define IDS_FMT_PTR_QUEUE                12
#define IDS_FMT_SPY_QUEUE                13
#define IDS_FMT_SPY_THE_SPY              14
#define IDS_FMT_SPY_WINDOW               15
#define IDS_FMT_STANDARD                 16
#define IDS_FMT_STANDARD_12              17
#define IDS_FMT_TITLE                    18
#define IDS_FMT_UNKNOWN_MSG              19
#define IDS_FMT_USER_MSG                 20

/* Column Headers */

#define IDS_HDR_HWND                     21
#define IDS_HDR_MSG                      22
#define IDS_HDR_MP1                      23
#define IDS_HDR_MP2                      24

/* HELP Panel titles */

#define IDS_HELP_TITLE_MAIN              25
#define IDS_HELP_TITLE_SELECTIVE         26
#define IDS_HELP_TITLE_GROUP             27
#define IDS_HELP_TITLE_NEWS              28
#define IDS_HELP_TITLE_DEFAULTS          29

/* Messages */

#define IDS_MSG_TOO_MANY_SPIES           30

/* Profile items */

#define IDS_PRO_DELIM                    31

#define IDS_PRO_HEADER                   32
#define IDS_PRO_COLOR_HEADER             33
#define IDS_PRO_DEFINE_HEADER            34
#define IDS_PRO_FIL_HEADER               35
#define IDS_PRO_LOG_HEADER               36
#define IDS_PRO_POS_HEADER               37
#define IDS_PRO_SET_HEADER               38

#define IDS_PRO_POS_FMT_X                39
#define IDS_PRO_POS_FMT_Y                40
#define IDS_PRO_POS_FMT_CX               41
#define IDS_PRO_POS_FMT_CY               42
#define IDS_PRO_SET_FMT_SPY              43
#define IDS_PRO_SET_FMT_LIST             44
#define IDS_PRO_LOG_FMT_FILE             45
#define IDS_PRO_END                      46
#define IDS_PRO_COLOR_FMT                47
#define IDS_PRO_DEFINE_FMT               48
#define IDS_PRO_DEFINE_FMT_COLOR         49
#define IDS_PRO_FILTER_FMT               50
#define IDS_PRO_GROUP_FMT                51

#define IDS_PRO_KW_COLOR                 52
#define IDS_PRO_KW_CX                    53
#define IDS_PRO_KW_CY                    54
#define IDS_PRO_KW_DEFINE                55
#define IDS_PRO_KW_EXCLUDE               56
#define IDS_PRO_KW_GROUP                 57
#define IDS_PRO_KW_INCLUDE               58
#define IDS_PRO_KW_LIST                  59
#define IDS_PRO_KW_LOG                   60
#define IDS_PRO_KW_MIN                   61
#define IDS_PRO_KW_SPYON                 62
#define IDS_PRO_KW_X                     63
#define IDS_PRO_KW_Y                     64
#define IDS_PRO_KW_COMMENT1              65
#define IDS_PRO_KW_COMMENT2              66

#define IDS_PRO_VALUE_ALL                67
#define IDS_PRO_VALUE_QUEUE              68
#define IDS_PRO_VALUE_WINDOW             69
#define IDS_PRO_VALUE_FREEZE             70
#define IDS_PRO_VALUE_THAWED             71
#define IDS_PRO_VALUE_STOPPED            72
#define IDS_PRO_VALUE_UNKNOWN            73

#define IDS_MSG_ALLOCATE                 74
#define IDS_MSG_PROFILE_EXISTS           75
#define IDS_MSG_LOG_EXISTS               76
#define IDS_HELP_TITLE_OW                77
#define IDS_FMT_SPY_OBJECT               78
#define IDS_MSG_FREE                     79

                                     /* === */

#define IDS_TOTAL                        80  /* must be last IDS_ item + 1 */

/************************************************************************/

// These are the messages internally used by PMSPY

typedef enum _SPY_MESSAGES
{
   // PMSPYDLL ===> PMSPY messages

   MSG_FROM_SPY_HOOK   = WM_USER,

   // PMSPY messages

   PMSPY_QUIT_NOTICE

} SPY_MESSAGES;


/************************************************************************/

#define IGNORE_THIS_MSG 0xFFFF

#define END_OF_ML       0xFFFF          /* @C6A - End of Msg List marker */

#define NO_MSG_SLOTS    251             /* PRIME # of MSG slots */

/************************************************************************/

#define GDataScope           near    /* @C11A 'scope' of global data items */

/*---------------------------------------------------------------------------+
| Typedef's                                                                  |
+---------------------------------------------------------------------------*/

typedef USHORT         MSG,                     /* PM message */
                     *PMSG,                     /* pointer to a PM message */
                     GROUP,                     /* PMSPY message GROUP */
                       IDS;                     /* @C10A STRINGTABLE index */

#define COLOR_BASE     'A'                      /* must be ASCII!!!! */

typedef enum {                                  /* logical colors */
               Color1        = 0,
               Color2,
               Color3,
               Color4,
               Color5,
               Color6,
               Color7,
               Color8,

               Color_Total,                     /* Total # logical colors */

               Color_Asis,                      /* leave color 'ASIS' value */
               Color_Error,                     /* used in reporting color errors */
               Color_Default = Color1,          /* Default color */

               Color_First   = Color1      + 1, /* One-origin first color index */
               Color_Last    = Color_Total      /* One-origin last  color index */

             } MSG_COLOR;

typedef enum { Single,
               Range,
               Default,
               EoT

             } MSG_TYPE;                        /* Msg Type */

typedef enum { Standard,
               User,
               UserDef,
               Unknown

             } MSG_FORMAT;                      /* Msg Format */

typedef enum { Yes,
               No_PassOn,
               No_EatMsg

             } MSG_WANTED;                      /* Msg wanted by us? */

typedef enum {                                  // PMSPY frame titles
               tStandard,
               tSpyWho,
               tWindow,
               tObject,
               tQueue

             } SPY_TITLES;

typedef struct { MSG_TYPE         Type;         /* Msg type          */

                 MSG              Msg,          /* specific Msg      */
                                  MsgHigh;      /* used if "range"   */

                 PSZ              pDesc;        /* MSG description   */

                 MSG_FORMAT       Style;        /* formatting style  */

                 BOOL             Include;      /* include msg?      */

                 MSG_WANTED       NoInclude;    /* what to do if not included */

                 MSG_COLOR        ClrFG;        /* @C1A logical FG color to DRAW */

                 GROUP            GroupID;      /* GROUP this msg defined in */

                 BOOL             SaveProcessed;/* processed during SAVE yet? */

               } MSG_ITEM, * PMSG_ITEM;         /* @C11C Msg control item  */

typedef struct _MSG_DATA
               {
                 struct _MSG_DATA *pNext;       /* Ptr(Next MSG in this slot) */

                 MSG_ITEM         item;

               } MSG_DATA, * PMSG_DATA;

typedef struct _MSG_SLOT
               {
                 PMSG_DATA        pFirst;       /* Ptr(1st MSG in this slot)
                                                **
                                                ** MUST be first field...
                                                */

                 USHORT           uNoMsgs;      /* # Msgs in this slot */

                 MSG              MsgLow,       /* Range of messages in this slot */
                                  MsgHigh;

               } MSG_SLOT, * PMSG_SLOT;

typedef struct {                                /* Programmer Defined Text Resource */

                 HMODULE          hModule;      /* handle of module to get PDTR from */

                 USHORT           typePDTR,     /* PDTR resource type ID */
                                  idPDTR;       /* ID of PDTR to process */

                 SEL              selPDTR;      /* SELector of loaded Resource */

                 PCHAR            pTOF,         /* Top-Of-File  pointer */
                                  pRead;        /* working READ pointer */

               } PDTR_DATA, * PPDTR_DATA;

typedef struct {                                /* Programmer Defined Text Resource */

                 PDTR_DATA        hPDTR;        /* HELP text resource info */

                 IDS              titleID;      /* HELP Dialog Title */

               } HELP_DATA, * PHELP_DATA;

typedef struct {                                /* Group List control */
                 GROUP            GroupID;      /* This GROUP's ID */

                 PSZ              pDesc;        /* Group's Description */

                 BOOL             Include;      /* @C10A include GROUP?*/

                 MSG_COLOR        ClrFG;        /* @C1A logical FG color to DRAW */

               } GRP_ITEM, * PGRP_ITEM;         /* @C11C Grp control item  */

typedef struct _GRP_DATA                        /* Group List control */
               {
                 struct _GRP_DATA *pNext;       /* Locates next GROUP */

                 GRP_ITEM          item;        /* Other Group Data */

               } GRP_DATA, * PGRP_DATA;         /* @C11C Grp control item  */

typedef struct {
                LONG lClrValue;              /* binary CLR value */
                PSZ  pszClrName;             /* ascii  CLR value */
               } XCOLOR, * PXCOLOR;

typedef struct {
                USHORT    iExtColor;      /* ExternalColorTranslation index */
                MSG_COLOR pbValue;        /* value to use if Pushbutton selected */

               } LOGCOLOR, * PLOGCOLOR;

typedef LOGCOLOR XLOGCOLOR[ Color_Total ];

typedef struct {
                 /********************************************
                 ****
                 **** MSG support data
                 ****
                 ********************************************/

                 USHORT       TotalMsgs;

                 MSG_SLOT     Msgs[NO_MSG_SLOTS];   /* MSG slot table */

                   /* "Process All Msgs" support data */

                 USHORT       ProcessAllMsgs_Slot;
                 PMSG_DATA    ProcessAllMsgs_pData;

                 /********************************************
                 ****
                 **** GROUP support data
                 ****
                 ********************************************/

                 GROUP        NextGroupID;  /* next GROUP ID */

                 PGRP_DATA    GroupHead,    /* locates GROUP table */
                              GroupTail;

                   /* "Process All Groups" support data */

                 PGRP_DATA    ProcessAllGroups_pGroup;

                 GROUP        ProcessAllMsgsInGroup_ID;

                 BOOL         ProcessAllMsgsInGroup_First,
                              ProcessAllGroups_First;

                 /********************************************
                 ****
                 **** COLOR support data
                 ****
                 ********************************************/

                 XLOGCOLOR    LogicalColorTranslation;

                 /********************************************
                 ****
                 **** Processing data
                 ****
                 ********************************************/


                BOOL          bWantUnknownMSG;

               } SPY_DATA, * PSPY_DATA;

/*---------------------------------------------------------------------------+
| Function declarations                                                      |
+---------------------------------------------------------------------------*/

MRESULT EXPENTRY SpyWindowProc(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2);

MRESULT EXPENTRY HelpWindowProc(         HWND    hwnd,
                                register USHORT  message,
                                         MPARAM  lParam1,
                                         MPARAM  lParam2 );

MRESULT EXPENTRY GroupDlgProc(         HWND    hwnd,         /* @C6A */
                              register USHORT  message,
                                       MPARAM  lParam1,
                                       MPARAM  lParam2 );

/* Filter Window handler procedure */

MRESULT EXPENTRY FilterDlgProc(          HWND    hwnd,
                                register USHORT  message,
                                         MPARAM  lParam1,
                                         MPARAM  lParam2 );
/* OBJECT Window selection dialog procedure */

MRESULT EXPENTRY ObjectDlgProc(          HWND    hwnd,
                                register USHORT  message,
                                         MPARAM  lParam1,
                                         MPARAM  lParam2 );

MRESULT EXPENTRY SpyLogoDlgProc(register HWND   hwnd,
                                register USHORT msg,
                                         MPARAM mp1,
                                         MPARAM mp2);

/**************************************************************************
* Define constants used by our DLL....
**************************************************************************/

typedef USHORT SPYEE;                  // PMSPY instance ID

#define SPY_BAD_SPYEE     ((SPYEE) -1) // unable to Register another SPYer
#define SPY_BAD_HWND      ((HWND)  -1) // invalid HWND value
#define SPY_BAD_HMQ       ((HMQ)   -1) // invalid HMQ  value
#define SPY_BAD_HAB       ((HAB)   -1) // invalid HAB  value

/**************************************************************************
* Define routines available from our DLL....
**************************************************************************/

       /**********************************************************
       * Routines for adding/removing PMSPY instances
       **********************************************************/

SPYEE  EXPENTRY SpyRegister         (HWND    hwndSpy,  // window to handle SPY data
                                     HAB     habSpy,   // HAB of window
                                     HMODULE modPFN);  // DLL handle

BOOL   EXPENTRY SpyDeRegister       (SPYEE idSpy);     // SPY instance

       /**********************************************************
       * Routines for dealing with a specific PMSPY instance
       **********************************************************/

BOOL   EXPENTRY SpySetTarget     (SPYEE idSpy,      // SPY instance
                                  HWND  hwndTarget, // Window to SPY
                                  HMQ   hmqTarget); // Queue  to SPY

BOOL   EXPENTRY SpyUnSetTarget   (SPYEE idSpy);     // SPY instance

HWND   EXPENTRY SpyQueryTargetWindow(SPYEE idSpy);     // SPY instance
HMQ    EXPENTRY SpyQueryTargetQueue (SPYEE idSpy);     // SPY instance

BOOL   EXPENTRY SpySetTargetIsWindow(SPYEE idSpy,      // SPY instance
                                     BOOL  fTargetIsWindow); // SPYing on window?

BOOL   EXPENTRY SpyQueryTargetIsWindow(SPYEE idSpy); // SPY instance

BOOL   EXPENTRY SpySetTargetMsgRange(SPYEE idSpy,      // SPY instance
                                     MSG   msgLow,     // lowest  MSG in range
                                     MSG   msgHigh);   // highest MSG in range

       /**********************************************************
       * Routines that returns PMSPY DLL information
       **********************************************************/

USHORT EXPENTRY SpyDllVersion(VOID);
USHORT EXPENTRY SpyQueryDllRegisterMax(VOID);

/**************************************************************************
* The guy who draws are SPYed data in columns...
**************************************************************************/
extern VOID DrawListBoxItem(POWNERITEM);

/**** PMSPYMSG.C routines ***************************************************/

extern VOID InitializeSpyData( register PSPY_DATA pSpy);
extern VOID ResetSpyData( register PSPY_DATA pSpy);

extern VOID InitializeMsg(register PSPY_DATA pSpy );

extern USHORT HashMsg(register MSG msg );

extern VOID AddMsg(PSPY_DATA pSpy,
                   PMSG_ITEM pMsg );

/* force ALL msgs to be (not) SPYed */

extern VOID IncludeAllMsgs(PSPY_DATA pSpy,
                           BOOL      Include,
                           MSG_COLOR Color);

/* force specific msg to be (not) SPYed */

extern VOID IncludeMsg(         PSPY_DATA pSpy,
                       register MSG       Msg,
                                BOOL      Include,
                                MSG_COLOR Color);

/* determine if specific msg is to be SPYed */

extern MSG_WANTED WantMsg(         PSPY_DATA pSpy,
                          register MSG  Msg );

/* format a specific msg */

extern PMSG_ITEM FormatMsg(PSPY_DATA pSpy,
                           PSZ       FormatArea,
                           HWND      Hwnd,
                           MSG       Msg,
                           MPARAM    Param1,
                           MPARAM    Param2 );

/* find a specific msg in the MSG_ITEM table */

extern PMSG_ITEM FindMsg(         PSPY_DATA pSpy,
                         register MSG       Msg );

extern PMSG_ITEM FindMsgName(PSPY_DATA pSpy,
                             PSZ       pName);

extern PMSG_ITEM ProcessFirstMsg(PSPY_DATA pSpy);
extern PMSG_ITEM ProcessNextMsg (PSPY_DATA pSpy);

extern BOOL DeleteMsg(         PSPY_DATA pSpy,
                      register MSG       Msg );

extern VOID DeleteAllMsgs( PSPY_DATA pSpy );

       /********************************************
       ****
       **** GROUP support routines       ****
       ********************************************/

extern VOID InitializeGroup(register PSPY_DATA pSpy );

extern GROUP AddGroup(PSPY_DATA pSpy,
                      PGRP_ITEM pGrp );

extern VOID IncludeGroup(         PSPY_DATA    pSpy,
                                  PGRP_ITEM    pGrp,
                         register BOOL         Include,
                         register MSG_COLOR    Color
                        );

extern PGRP_ITEM FindGroup(         PSPY_DATA pSpy,
                           register GROUP     GroupID);

extern PGRP_ITEM FindGroupName(PSPY_DATA pSpy,
                               PSZ       pName);

extern PMSG_ITEM ProcessFirstMsgInGroup(         PSPY_DATA pSpy,
                                        register GROUP     GroupID);

extern PMSG_ITEM ProcessNextMsgInGroup(PSPY_DATA pSpy);

extern PGRP_ITEM ProcessFirstGroup(register PSPY_DATA pSpy );

extern PGRP_ITEM ProcessNextGroup(register PSPY_DATA pSpy);

extern BOOL      DeleteGroup(         PSPY_DATA pSpy,
                             register GROUP     GroupID);

extern VOID      DeleteAllGroups(register PSPY_DATA pSpy);

/**** PMSPYUTL.C routines ***************************************************/

extern USHORT MsgDisplay( HWND   hWnd,
                          PSZ    strCap,
                          PSZ    strFormat,
                          USHORT mb_id,
                          USHORT style,
                          ...);

extern VOID   UpdateSpyTitle( HWND         hwndFrame,
                              SPY_TITLES   whichTitle,
                              ...);

extern BOOL ConvertToNumber(PSZ      pAscii,
                            PUSHORT  pNumber,
                            USHORT   lMin,
                            USHORT   lMax);

typedef struct {                        /* Memory Allocation control structure */

                 ULONG  nAllocs,
                        sAllocs,
                        nFrees;
               } MEM_DATA, *PMEM_DATA;

extern PVOID AllocateMemory(register USHORT uSizeWanted );

extern VOID  FreeMemory(register PVOID p );

extern VOID  QueryMemory(register PMEM_DATA p );

extern PPDTR_DATA OpenPDTR(register PPDTR_DATA pData);

extern BOOL       EofPDTR( register PPDTR_DATA pData);

extern PSZ        GetsPDTR(         PPDTR_DATA pData,
                           PSZ      pString,
                           register USHORT     lString);

extern int        ClosePDTR(register PPDTR_DATA pData);

typedef struct { PSZ    *ppWord;      /* pointer to PSZ for this WORD */
                 USHORT  vWord;       /* Value if this WORD found */
               } WORD_LIST, *PWORD_LIST;

extern USHORT FindWordInList(PSZ pWord, PWORD_LIST pWordList);

extern PSZ    TranslateClassName(PSZ pszClassName);

/**** PMSPYPRO.C routines ***************************************************/

BOOL OpenProfile(HWND      hwndCur,
                 HWND      hwndFrame,
                 PSPY_DATA pSpy,
                 PSZ       szFile);

BOOL SaveProfile(HWND hwnd, PSPY_DATA pSpy, PSZ szFile);                            /* @C9A */

extern VOID      SetColors( HWND hwnd );
extern MSG_COLOR GetColor ( HWND hwnd );

/*---------------------------------------------------------------------------+
| Variable declarations                                                      |
+---------------------------------------------------------------------------*/

/* determine SCOPE to use on global variables */


#if defined(DEFINE_VARIABLES)

   #define xSCOPE
   #define iGLOBAL(init) = init         /*  specify initialization            */

#else

   #define xSCOPE extern
   #define iGLOBAL(init)                /*  do not specify initialization     */

#endif

#define genXCT(color)    { color, #color }

#if !defined(SYSCLR_INACTIVETITLETEXT)

#define SYSCLR_ACTIVETITLETEXT         CLR_PINK
#define SYSCLR_ACTIVETITLETEXTBGND     CLR_PINK
#define SYSCLR_BUTTONDARK              CLR_PINK
#define SYSCLR_BUTTONDEFAULT           CLR_PINK
#define SYSCLR_BUTTONLIGHT             CLR_PINK
#define SYSCLR_BUTTONMIDDLE            CLR_PINK
#define SYSCLR_DIALOGBACKGROUND        CLR_PINK
#define SYSCLR_HILITEBACKGROUND        CLR_PINK
#define SYSCLR_HILITEFOREGROUND        CLR_PINK
#define SYSCLR_ICONTEXT                CLR_PINK
#define SYSCLR_INACTIVETITLETEXT       CLR_PINK
#define SYSCLR_INACTIVETITLETEXTBGND   CLR_PINK
#define SYSCLR_OUTPUTTEXT              CLR_PINK
#define SYSCLR_SHADOW                  CLR_PINK
#define SYSCLR_TITLEBOTTOM             CLR_PINK

#endif

xSCOPE XCOLOR  ExternalColorTranslation[]

#if defined(DEFINE_VARIABLES)

= {
   /* These are the 'default' colors */

   genXCT(SYSCLR_WINDOWTEXT             ),         // Color #1
   genXCT(SYSCLR_ACTIVETITLE            ),         // Color #2
   genXCT(SYSCLR_WINDOWSTATICTEXT       ),         // Color #3
   genXCT(   CLR_RED                    ),         // Color #4
   genXCT(   CLR_PINK                   ),         // Color #5
   genXCT(   CLR_GREEN                  ),         // Color #6
   genXCT(   CLR_CYAN                   ),         // Color #7
   genXCT(   CLR_YELLOW                 ),         // Color #8

   /* These are the standard 'SYSCLR' colors */

   genXCT(SYSCLR_ACTIVEBORDER           ),
   genXCT(SYSCLR_ACTIVETITLETEXT        ),
   genXCT(SYSCLR_ACTIVETITLETEXTBGND    ),
   genXCT(SYSCLR_APPWORKSPACE           ),
   genXCT(SYSCLR_BACKGROUND             ),
   genXCT(SYSCLR_BUTTONDARK             ),
   genXCT(SYSCLR_BUTTONDEFAULT          ),
   genXCT(SYSCLR_BUTTONLIGHT            ),
   genXCT(SYSCLR_BUTTONMIDDLE           ),
   genXCT(SYSCLR_DIALOGBACKGROUND       ),
   genXCT(SYSCLR_HELPBACKGROUND         ),
   genXCT(SYSCLR_HELPHILITE             ),
   genXCT(SYSCLR_HELPTEXT               ),
   genXCT(SYSCLR_HILITEBACKGROUND       ),
   genXCT(SYSCLR_HILITEFOREGROUND       ),
   genXCT(SYSCLR_ICONTEXT               ),
   genXCT(SYSCLR_INACTIVEBORDER         ),
   genXCT(SYSCLR_INACTIVETITLE          ),
   genXCT(SYSCLR_INACTIVETITLETEXT      ),
   genXCT(SYSCLR_INACTIVETITLETEXTBGND  ),
   genXCT(SYSCLR_MENU                   ),
   genXCT(SYSCLR_MENUTEXT               ),
   genXCT(SYSCLR_OUTPUTTEXT             ),
   genXCT(SYSCLR_SCROLLBAR              ),
   genXCT(SYSCLR_SHADOW                 ),
   genXCT(SYSCLR_TITLEBOTTOM            ),
   genXCT(SYSCLR_TITLETEXT              ),
   genXCT(SYSCLR_WINDOW                 ),
   genXCT(SYSCLR_WINDOWFRAME            ),

   /* These are the standard 'CLR' colors */

   genXCT(   CLR_BACKGROUND             ),
   genXCT(   CLR_BROWN                  ),
   genXCT(   CLR_BLACK                  ),
   genXCT(   CLR_BLUE                   ),
   genXCT(   CLR_DEFAULT                ),
   genXCT(   CLR_DARKBLUE               ),
   genXCT(   CLR_DARKCYAN               ),
   genXCT(   CLR_DARKGRAY               ),
   genXCT(   CLR_DARKGREEN              ),
   genXCT(   CLR_DARKPINK               ),
   genXCT(   CLR_DARKRED                ),
   genXCT(   CLR_NEUTRAL                ),
   genXCT(   CLR_PALEGRAY               ),
   genXCT(   CLR_WHITE                  ),

   /* end-of-table marker */

   {    CLR_ERROR             , NULL }
  }
#endif

;

xSCOPE SPY_DATA  spyData;

xSCOPE PSPY_DATA pSpyData             iGLOBAL( &spyData );

xSCOPE HAB      hab                   iGLOBAL( NULL );

xSCOPE HWND     hwndFrame             iGLOBAL( NULL ),  /* FRAME window handle */
                hwndClient            iGLOBAL( NULL ),  /* CLIENT area window handle */
                hwndMsgList           iGLOBAL( NULL ),  /* Msg list scroll list window handle */
                hwndMenu              iGLOBAL( NULL );


xSCOPE HMQ      hmq                   iGLOBAL( NULL );

xSCOPE HSWITCH  hSwitch               iGLOBAL( NULL );

xSCOPE SWCNTRL  swcntrl;

xSCOPE BOOL     bSelecting           iGLOBAL( FALSE ),
                bSuspendMsgDisplay   iGLOBAL( FALSE ),
                bWindowIsObject      iGLOBAL( FALSE );

xSCOPE SPYEE    SpyInstance          iGLOBAL( SPY_BAD_SPYEE ); // Instance #

xSCOPE USHORT   NbrOfMessages        iGLOBAL( 0 ),
                MaxNbrOfMessages     iGLOBAL( 0 );  /* dynamically set from .RC */

xSCOPE HPOINTER hSpy                 iGLOBAL( NULL ),
                hOld                 iGLOBAL( NULL );

xSCOPE HMODULE  hSpyDll              iGLOBAL( NULL );

xSCOPE POINTL   ptrPos;

xSCOPE FONTMETRICS metrics;           /* General font information */

xSCOPE PSZ      Strings[IDS_TOTAL];   /* pointer to loaded STRINGTABLE items */

/* Logfile variables  */                                                 /* @C3A */

xSCOPE CHAR     szLogDrive[FILEDLG_DRIVE_LENGTH];                        /* @C3A */
xSCOPE CHAR     szLogPath[FILEDLG_PATH_LENGTH];                          /* @C3A */
xSCOPE CHAR     szLogFile[FILEDLG_FILE_LENGTH] iGLOBAL({"PMSPY.LOG"});   /* @C3A */
xSCOPE CHAR     szLogPattern[FILEDLG_PATTERN_LENGTH] iGLOBAL({"*.LOG"}); /* @C3A */

xSCOPE FILE     *pLogFile iGLOBAL(NULL);                                 /* @C3A */
xSCOPE BOOL     bCurrentlyLogging iGLOBAL(FALSE);                        /* @C3A */
xSCOPE INT      xMaxMsgLength iGLOBAL(0);                                /* @C3A */

xSCOPE PSZ      pszFmtStd     iGLOBAL(NULL);

/* Profile variables  */                                                 /* @C9A */

xSCOPE CHAR     szProDrive[FILEDLG_DRIVE_LENGTH];                        /* @C9A */
xSCOPE CHAR     szProPath[FILEDLG_PATH_LENGTH];                          /* @C9A */
xSCOPE CHAR     szProFile[FILEDLG_FILE_LENGTH] iGLOBAL({""});            /* @C9A */
xSCOPE CHAR     szProPattern[FILEDLG_PATTERN_LENGTH] iGLOBAL({"*.PRO"}); /* @C9A */

/* Command line support */                                               /* @C8A */

xSCOPE char     *(*ArgV)[];                                              /* @C8A */
xSCOPE int      ArgC;                                                    /* @C8A */
